<p align="center">
    <br>
    <br>
    <a href="https://backpackforlaravel.com" title="Backpack Logo"><img src="https://backpackforlaravel.com/presentation/img/backpack/logos/backpack_logo.svg" width="450px"></a>    
    <br>
    <br>
</p>


<h3 align="center">Quickly build an admin panel for your Eloquent models, then customize every little detail.</h3>


<p align="center">
    <br>
    <a href="https://packagist.org/packages/backpack/crud" title="Latest Version on Packagist"><img src="https://img.shields.io/packagist/v/backpack/crud.svg?style=flat-square"></a>
    <a href="https://packagist.org/packages/backpack/crud" title="Total Downloads"><img src="https://img.shields.io/packagist/dt/backpack/crud.svg?style=flat-square"></a>
    <a href="https://github.com/Laravel-Backpack/CRUD/commits/master" title="Last commit"><img alt="GitHub last commit" src="https://img.shields.io/github/last-commit/laravel-backpack/crud"></a>
    <a href="https://scrutinizer-ci.com/g/laravel-backpack/crud" title="Quality Score"><img src="https://img.shields.io/scrutinizer/g/laravel-backpack/crud.svg?style=flat-square"></a>
    <a href="https://styleci.io/repos/53581270" title="Style CI"><img src="https://styleci.io/repos/53581270/shield"></a>
    <a href="https://scrutinizer-ci.com/g/laravel-backpack/crud/code-structure" title="Coverage Status"><img src="https://raw.githubusercontent.com/laravel-backpack/CRUD/coverage-badge-dont-delete/test-coverage.svg"></a>
    <a href="LICENSE.md" title="Software License"><img src="https://img.shields.io/github/license/laravel-backpack/crud?style=flat-square"></a>
    <a href="https://github.com/the-whole-fruit/manifesto"><img src="https://img.shields.io/badge/writing%20standard-the%20whole%20fruit-brightgreen?style=flat-square" title="We believe writing good code is not only about writing good code. It’s also about the words around it. We aims to deliver both: code and words."></a>
</p>



https://user-images.githubusercontent.com/33960976/228454020-91f42000-919e-413c-92c7-d406725f6dd2.mp4


-----

Among the FREE features of each admin interface:
- [List](https://backpackforlaravel.com/docs/crud-operation-list-entries) operation
   - 24 column types
   - 1-1, 1-n and n-n relationships
   - table view with search, pagination
   - click column header to sort by it
   - custom buttons
   - details row
   - easily create new column types
   - easily override an existing column type
- [Create](https://backpackforlaravel.com/docs/crud-operation-create) / [Update](https://backpackforlaravel.com/docs/crud-operation-update) operations
   - 29 field types
   - back-end validation using Laravel Form Requests
   - translatable models (multi-language)
   - have multiple fields per line
   - split fields into tabs
- [Delete](https://backpackforlaravel.com/docs/crud-operation-delete) operation
- [Reorder](https://backpackforlaravel.com/docs/crud-operation-reorder) operation
- [Revise](https://backpackforlaravel.com/docs/crud-operation-revisions) operation (aka. audit log)

But professionals love it not only because it is feature-packed. They also love it because it's **ridiculously easy to override a functionality**. Generally, you just need to create a function (or blade file) with the right name. Yes, it can be _that_ easy.

> Need more complex features? Purchase [Backpack PRO](https://backpackforlaravel.com/pricing), our closed-source paid add-on. It will add **5 more operations, 10 filters, 28 more fields, 6 more columns and 1 more widget**. For more info, see our [FREE vs PRO comparison table](https://backpackforlaravel.com/docs/features-free-vs-paid). We believe it's everything you need to build admin panels of _any_ complexity.

## Links

<p align="left">
    <a href="https://backpackforlaravel.com/">Website</a> &nbsp; • &nbsp; 
    <a href="https://backpackforlaravel.com/docs/">Documentation</a> &nbsp; • &nbsp;  
    <a href="https://backpackforlaravel.com/addons">Add-ons</a> &nbsp; • &nbsp; 
    <a href="https://backpackforlaravel.com/pricing">Pricing</a> &nbsp; • &nbsp; 
    <a href="https://backpackforlaravel.com/need-freelancer-or-development-team">Services</a> &nbsp; • &nbsp; 
    <a href="https://stackoverflow.com/questions/tagged/backpack-for-laravel">Stack Overflow</a> &nbsp; • &nbsp; 
    <a href="https://backpackforlaravel.com/articles">Blog</a> &nbsp; • &nbsp; 
    <a href="https://backpackforlaravel.com/newsletter">Newsletter</a>
</p>

## Demo

Please see [demo.backpackforlaravel.com](https://demo.backpackforlaravel.com/admin). Here's a sneak peek:

<a href="https://backpackforlaravel.com/" title="Backpack Screenshots Spread"><img src="https://user-images.githubusercontent.com/1032474/86720524-c5a1d480-c02d-11ea-87ed-d03b0197eb25.gif"></a>

## Getting Started

Start with the ["Introduction" page in our docs](https://backpackforlaravel.com/docs/introduction) in our docs. It will explain what you can do with Backpack, and let you choose a guide, depending on how you like to learn:
- a 59-minute ["Getting Started" video course](https://backpackforlaravel.com/docs/getting-started-videos);
- a 20-minute ["Getting Started" text course](https://backpackforlaravel.com/docs/getting-started-basics);
- a 4-day, 5min/day ["Getting Started" drip email course](https://sendy.digitallyhappy.com/subscription?f=jlldf83763papd2Ifee0838Xs65TkXSvi17yEAuEnJiNj9ct53p5tikGHM4OkvpCeFUCbwcEYRt763ZSTILFXRWWEQ);

## Install

For the current version (recommended):
- [Install Backpack v6 on Laravel 10, 11 & 12](https://backpackforlaravel.com/docs/installation);

For the previous versions (not recommended):
- [Install Backpack v5 on Laravel 10, 9 or 8](https://backpackforlaravel.com/docs/5.x/installation)  - last feature update was 27th April 2023;
- [Install Backpack 4.1 on Laravel 6, 7 or 8](https://backpackforlaravel.com/docs/4.1/installation) - last feature update was 1st Jan 2021;
- [Install Backpack 4.0 on Laravel 5.8, 6 or 7](https://backpackforlaravel.com/docs/4.0/installation) - last feature update was 21st Apr 2020;
- [Install Backpack 3.6 on Laravel 5.8 or 6.x](https://backpackforlaravel.com/docs/3.6/installation) - last feature update was 17th Sep 2019;
- [Install Backpack 3.5 on Laravel 5.5, 5.6, 5.7](https://backpackforlaravel.com/docs/3.5/installation) - last feature update was 27th Feb 2019;
- [Install Backpack 3.x on Laravel 5.4](https://laravel-backpack.readme.io/docs/install-on-laravel-54) - last feature update was 27 Sep 2017;
- [Install Backpack 3.x on Laravel 5.3](https://laravel-backpack.readme.io/docs/installation-on-laravel-53) - last feature update was 02 Feb 2017;
- [Install Backpack 3.x on Laravel 5.2](https://laravel-backpack.readme.io/docs/installation) - deprecated, lacks a lot of features;

## Change Log

Please see [the Releases tab](https://github.com/Laravel-Backpack/CRUD/releases). 

## Security

> It's _heavily_ recommended that you **[subscribe to the Backpack Newsletter](http://backpackforlaravel.com/newsletter)** so you can find out about any security updates, breaking changes or major features. We send an email about 1-2 emails per year. Sometimes less.

If you discover any security related issues, please email hello@backpackforlaravel.com instead of using the issue tracker.

## License

Backpack is open-core:
- **Backpack CRUD is licensed under the [MIT License](LICENSE.md)** (open-source free software); it is perfect if you're building a simple admin panel - it's packed with features! It's also perfect if you're building an open-source project, the permissive license allows you to do whatever you want;
- **Backpack PRO is licensed under our [EULA](https://backpackforlaravel.com/eula)**; it is a closed-source, paid add-on; [PRO](https://backpackforlaravel.com/products/pro) will be useful when your admin panel needs grow, because it adds A LOT of features for complex use cases (see our [FREE vs PRO comparison](https://backpackforlaravel.com/docs/features-free-vs-paid));

[Our documentation](https://backpackforlaravel.com/docs) covers both CRUD and PRO, with all the PRO features clearly labeled <span class="badge badge-pill badge-info">PRO</span>. You do not _need_ PRO, that is just an add-on. But we're hoping you find it useful, and pay for it, to support the development of our open-core.

<a name="versioning"></a>
## Versioning

Our packages follow [semantic versioning](https://semver.org/). Here's what `major.minor.patch` (eg. `6.0.1`) means for us:
- `major` - breaking changes, major new features, complete rewrites; released **once a year**, in the first quarter; it adds features that were previously impossible and upgrades our dependencies; upgrading is done by following our clear and detailed upgrade guides;
- `minor` - new features, released in backwards-compatible ways; **every few months**; update takes seconds;
- `patch` - bug fixes & small non-breaking changes; historically **every week**; update takes seconds;

When we release a new Backpack\CRUD version, all premium addons receive support for it the same day. When you buy a premium Backpack addon, you get access to not only _updates_, but also _upgrades_ (for 12mo), that means that... **any time you buy a Backpack addon, it is very likely that you're not only buying the _current_ version** (`v6` at the moment), **but also the upgrade to the _next version_** (`v7` for example).

## Contributing Guidelines

This project stands by [The Whole Fruit Manifesto](https://github.com/the-whole-fruit/manifesto). We believe that “_writing good code_” is not only about “_writing good code_”. It’s also about the words around it. That’s why, to make sure your contribution is well received, we ask you to [read and keep in mind the ONE=MOR framework and guidelines](https://github.com/the-whole-fruit/manifesto) when writing comment blocks, PR titles, PR descriptions, and in general, when writing to our community. 

For tasks & details about how you can help our project, please see [CONTRIBUTING](CONTRIBUTING.md).

## Credits

- [Cristian Tabacitu](http://tabacitu.ro) - founder & lead maintainer;
- [Pedro Martins](https://github.com/pxpm) - senior maintainer;
- [António Almeida](https://github.com/promatik) - senior maintainer;
- [Karan Datwani](https://github.com/karandatwani92) - maintainer & social media manager;
- [Jorge Castro](https://github.com/jcastroa87) - maintainer;
- [290+ wonderful contributors][link-contributors]

Special thanks go to:
- [Mauro Martinez](https://github.com/maurohmartinez), [Owen Melbourne](https://github.com/OwenMelbz), [Oliver Ziegler](https://github.com/OliverZiegler), [Thomas Swonke](https://github.com/tswonke), [Catalin Tudorache](https://github.com/ctudorache87), [Abby Janke](https://github.com/AbbyJanke), [David Lloyd](https://github.com/lloy0076) - A LOT of new features, bug fixing, support, feedback and code review;
- [Paweł Kuna](https://github.com/codecalm/) - creator of Tabler;
- [Łukasz Holeczek](https://github.com/mrholek/) - creator of CoreUI;
- [Taylor Otwell](https://github.com/taylorotwell) & the wonderful Laravel community (of course);
- everybody who's ever purchased a Backpack license; it's thanks to them that we get to do this daily 🙏

## Hire us

We've spent more than 10,000 hours creating, polishing and maintaining administration panels on Laravel. We've developed e-Commerce, e-Learning, ERPs, social networks, payment gateways and much more. We've worked on admin panels _so much_, that we've created one of the most popular packages for Laravel - just from making public what was repetitive in our projects.

If you are looking for a developer/team to help you build an admin panel on Laravel, look no further. You'll have a difficult time finding someone with more experience & enthusiasm for admin panels. This is _what we do_. [Contact us](https://backpackforlaravel.com/need-freelancer-or-development-team).



[ico-version]: https://img.shields.io/packagist/v/dick/crud.svg?style=flat-square
[ico-license]: https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat-square
[ico-downloads]: https://img.shields.io/packagist/dt/tabacitu/crud.svg?style=flat-square

[link-packagist]: https://packagist.org/packages/backpack/crud
[link-downloads]: https://packagist.org/packages/backpack/crud
[link-author]: https://tabacitu.ro
[link-contributors]: ../../contributors
