<?php
$debug  = false;
$debug1 = true;

// ~ Get the PHP Version number set for the server/domain
$version    = phpversion();           // e.g., "8.2.10"
$parts      = explode('.', $version);   // ["8", "2", "10"]
$phpVersion = $parts[0] . '.' . $parts[1];

if ($debug) {
	echo "<pre>";
	echo "PHP Version: $phpVersion<br/>";
	echo "</pre>";
	die;
}


echo "PHP Extensions for Verification Report PHP $phpVersion <br>";
echo "=======================================================<br>";

// ~ Load the required extensions from file
$filename           = "extensions-list-PHP{$phpVersion}.json";
$requiredExtensions = json_decode(file_get_contents($filename), true);

// ~ Get installed extensions on this instance
$installedExtensions = get_loaded_extensions();

// ~ Check for missing extensions
$missingExtensions = array_diff($requiredExtensions, $installedExtensions);

if (empty($missingExtensions)) {
	echo "👍👍👍 All required extensions have been installed 👍👍👍 <br>";
	echo "===================================++++++====================<br>";
} else {
	echo "🙁🙁🙁<h2>Attention: Missing Extensions List</h2>🙁🙁🙁<br/>";
	echo "<pre>";
	echo var_dump($missingExtensions) . "<br />"; // Output to screen
	echo "----------------------------------------------------------<br/>";
	echo "</pre>";
}

// echo "<br/>---- phpinfo listing for server...<br/>";
echo phpinfo();
