<?php

echo "ODBC Driver for SQL Server Verification Report V2<br>";
echo "=================================================<br>";

$odbcPresent = [];

// List of common SQL Server ODBC driver names to test
$drivers = [
    '{ODBC Driver 18 for SQL Server}',
    '{ODBC Driver 17 for SQL Server}',
    // '{SQL Server Native Client 11.0}',
    // '{SQL Server Native Client 10.0}',
    // '{SQL Server}',
];

// Test each driver name by attempting a connection
foreach ($drivers as $driver) {
    echo "Testing for: $driver<br>";
    $dsn        = "Driver=$driver;Server=137.59.109.53;Encrypt=yes;TrustServerCertificate=yes";
    $connection = @odbc_connect($dsn, 'sa', '9MNTAPdtL3xnfs');

    if ($connection) {
        // Connection succeeded, driver is installed
        odbc_close($connection);
        $odbcPresent[] = $driver;
    } else {
        echo "<br>Error for $driver: " . odbc_errormsg();
    }
}

if (empty($odbcPresent)) {
    echo "<br />🙁🙁🙁 unable to connect SQLServer in IP 137.59.109.53 using these ODBC drivers 🙁🙁🙁<br/>";
    echo "OR These drivers are missing in the server being tested<br/>";
} else {
    echo "<pre>";
    echo "<br/><h2>👍👍👍 List of Drivers Tried and Found 👍👍👍 </h2>";
    echo "----------------------------------------------------------<br/>";
    echo var_dump($odbcPresent) . "<br  />"; // Output to screen
    echo "----------------------------------------------------------<br/>";
    echo "</pre>";

}

echo phpinfo();

// emassnippets/test-odbc-sqlserver-driver.php
