<?php
// =====================================================================================================
// Speed Test  - MYSQL Database on reports.emastpa.com.my
// ======================================================================================================
//  call this script: domain/location/emassnippets/mysqlspeedtest.php?server=<server name>
//  where server name 
//  is 
//      reports.emastpa.com.my  = reports
//      crm.emastpa.com.my = crm
//      dispensing.mytigas.com = dispensing
//      dms.emastpa.com.my = dms
//
//===============================================================================================
//
//
$debug       = false;
$debug1      = true;          // set if required to execute all the debug codes
$errormsg    = "";
$hostname    = gethostname();
$servername  = $_GET["server"];
$limit       = intval($_GET["limit"]);
$servertitle = strtoupper($servername);

$servertable                  = [];
$servertable["reports"][0]    = "mysql:host=reports.emastpa.com.my;dbname=emasreport_adhocdb";
$servertable["reports"][1]    = "emasreport_crmdba";
$servertable["reports"][2]    = "Sathya2017";
$servertable["crm"][0]        = "mysql:host=crm.emastpa.com.my;dbname=crmemast_adhocdb";
$servertable["crm"][1]        = "crmemast_crmdba";
$servertable["crm"][2]        = "Sathya2017";
$servertable["dispensing"][0] = "mysql:host=dispensing.mytigas.com;dbname=tigasdispensing_adhocdb";
$servertable["dispensing"][1] = "tigasdispensing_tigasdba";
$servertable["dispensing"][2] = "Tigasdba2020$$";
$servertable["dms"][0]        = "mysql:host=dms.emastpa.com.my;dbname=dmsemastpa_adhocdb";
$servertable["dms"][1]        = "dmsemastpa_crmdba";
$servertable["dms"][2]        = "Sathya2017";
// $servertable["emastpa"][0]    = "mysql:host=137.59.109.53;dbname=test";
// $servertable["emastpa"][1]    = "SOLIDSNAKE";
// $servertable["emastpa"][2]    = "9MNTAPdtL3xnfs";
// $servertable["aumsystem"][0]  = "mysql:host=72.18.130.41;dbname=aumsyste_adhocdb";
// $servertable["aumsystem"][1]  = "aumsyste_aumdb";
// $servertable["aumsystem"][2]  = "Aumdb2020$$";

if ($debug) {
    echo "<pre>";
    echo print_r($servertable) . "<br />";
    echo "</pre>";
}
$emastdbparam[0] = $servertable[$servername][0];
$emastdbparam[1] = $servertable[$servername][1];
$emastdbparam[2] = $servertable[$servername][2];

if ($debug) {
    echo "<pre>";
    echo print_r($emastdbparam) . "<br />";
    echo "</pre>";
}
echo "======= TEST ON '{$emastdbparam[0]}' database (FROM '{$hostname}' Server) =======<br />";

//
// =============== Connect to emas_tpa Database ===================
//

try {
    $emasthandle = new PDO($emastdbparam[0], $emastdbparam[1], $emastdbparam[2]);
    $emasthandle->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

} catch (PDOException $e) {
    $errormsg = "Connection - " . $emastdbparam[0] . " failed: " . $e->getMessage();
    //  trigger_error($errormsg, E_USER_ERROR);
    if ($debug) {
        echo "<pre>";
        echo print_r($errormsg) . "<br />";
        echo "</pre>";
    }
    return;
}
if ($debug) {
    echo "<pre>";
    echo "Connection to {$servertitle} Server Successful <br />";
    echo "</pre>";
}
//
//================= Check if Temp Table exist and drop ===============

$dropbp016temp = "DROP TABLE IF EXISTS emasspeedtest";
$emasthandle->exec($dropbp016temp);
//
// ================ Create Temporay Table in emas_tpa ================
//

$bp016struct = "CREATE TABLE `emasspeedtest` (
    `Id` INT NOT NULL AUTO_INCREMENT,
    `ClaimId` INT NULL,
    `ClaimDate` DATETIME NULL,
    `MemberId` INT NULL,
    `CorpId` INT NULL,
    `ProviderId` INT NULL,
    `PatientName` VARCHAR(255) NULL,
    `CollReference` VARCHAR(50) NULL,
    `PayorderNum` VARCHAR(255) NULL,
    `Status` VARCHAR(45) NULL,
    `ClosedDate` DATE NULL,
    `AdjmentFlag` INT(1) NULL,
    `FinalAmount` DECIMAL(12,2) NULL,
    `Advdate` DATETIME NULL,
    PRIMARY KEY (`Id`));";

if ($debug) {
    echo "<pre>";
    echo "====  emasspeedtest structure ========<br />";
    echo print_r($bp016struct) . "<br />";
    echo "</pre>";
}

try {
    $emasthandle->exec($bp016struct);
} catch (PDOException $e) {
    $errormsg = "emasspeedtest Table Creation Failed: " . $e->getMessage();
    //  trigger_error($errormsg, E_USER_ERROR);
    if ($debug) {
        echo "<pre>";
        echo print_r($errormsg) . "<br />";
        echo "</pre>";
    }
    return;
}
if ($debug) {
    echo "<pre>";
    echo "emasspeedtest Table Creation Successful <br />";
    echo "</pre>";
}


$fldvalues = "
    '123456',
    '2019-01-01',
    '111111',
    '222222',
    '333333',
    'Murugappan Ramanathan',
    'HSBC 192939',
    'abc-123456',
    'Paid',
    '2019-03-02',
    '0',
    '234.75',
    NULL";

if ($debug) {
    echo "<pre>";
    echo " =====Field values ===== <br />";
    echo "print_r($fldvalues)";
    echo "</pre>";
}

if ($debug) {
    $continueloop = true;
} else {
    $continuellop = false;
}

$counter = 0;

$starttime     = strtotime(date("Y-m-d H:i:s"));
$startdatetime = date("Y-m-d H:i:s");

while ($continueloop) {
    if ($counter >= $limit) {
        $continueloop = false;
        continue;
    }

    $counter++;
    $emastquery = "Insert into emasspeedtest (
        ClaimId,
        ClaimDate,
        MemberId,
        CorpId,
        ProviderID,
        PatientName,
        CollReference,
        PayorderNum,
        Status,
        ClosedDate,
        AdjmentFlag,
        FinalAmount,
        AdvDate)
    Values ($fldvalues)";
    if ($debug) {
        echo "<pre>";
        echo "======== emastquery dump =========== <br />";
        echo print_r($emastquery) . "<br />";
        echo "</pre>";
    }

    try {
        $emasthandle->exec($emastquery);
    } catch (PDOException $e) {
        $errormsg = "insert to emasspeedtest Failed: " . $e->getMessage();
        //  trigger_error($errormsg, E_USER_ERROR);
        if ($debug) {
            echo "<pre>";
            echo print_r($errormsg) . "<br />";
            echo "</pre>";
        }
        $continueloop = false;
        continue;
    }
    if ($debug) {
        echo "<pre>";
        echo "==== Insert row $counter into emasspeedtest Successful=========== <br />";
        echo "</pre>";
    }

}

$endtime     = strtotime(date("Y-m-d H:i:s"));
$enddatetime = date("Y-m-d H:i:s");
$timediff    = abs($endtime - $starttime) / 60;
$rowrate     = round($limit / ($endtime - $starttime), 2, PHP_ROUND_HALF_DOWN);
echo "<pre>";
echo " End of Speed Test (Insert) - MYSQL Database on {$servertitle} server<br />";

echo "==== $counter loops completed <br />";
echo "==== Startdatetime1 $startdatetime === <br />";
echo "==== enddatetime $enddatetime === <br />";
echo "==== Starttime $starttime === <br />";
echo "==== endtime $endtime === <br />";
echo "=== Time taken is : $timediff in min:secs ===<br />";
echo "=== Row insert rate is : $rowrate rows per sec ===<br />";

echo "</pre>";

$emasthandle = NULL;

?>